IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_INTEGRA_PROPZ_EVENTOS')
BEGIN
	DROP TRIGGER TRG_RC_CLI_INTEGRA_PROPZ_EVENTOS
END
GO
CREATE OR ALTER TRIGGER TRG_RC_CLI_INTEGRA_PROPZ_EVENTOS ON RC_CLI
FOR INSERT, UPDATE 
AS  
  UPDATE A SET 
    A.ST_EVENTO = 4 
  FROM INSERTED I 
  JOIN INTEGRA_PROPZ_EVENTOS A ON(I.CD_CLI = A.CD_REGISTRO)
  WHERE A.ST_EVENTO = 3
  AND A.TABELA = 'RC_CLI'


  INSERT INTO INTEGRA_PROPZ_EVENTOS(TABELA, CD_EMP, CD_FILIAL, CD_REGISTRO, TP_EVENTO, DT_ULT_ALT, CD_USU, DT_DOCUMENTO)
  SELECT	
    'RC_CLI'                           AS TABELA,
	RC_CLI.CD_EMP                      AS CD_EMP,
	RC_CLI.CD_FILIAL                   AS CD_FILIAL,
	RC_CLI.CD_CLI                      AS CD_REGISTRO,
	1                                  AS TP_EVENTO,
	RC_CLI.DT_ULT_ALT                  AS DT_ULT_ALT,
	RC_CLI.CD_USU                      AS CD_USU,
	GETDATE()                          AS DT_DOCUMENTO
  FROM INSERTED RC_CLI
  WHERE RC_CLI.CD_EMP = 1